/*
 * efnet-pl, Copyright (C) 2004-2007 Adam Wysocki
 *
 * Najnowsza wersja: http://www.chmurka.net/p/efnet-pl.zip
 * Skargi i wnioski: Adam Wysocki, gophi <at> chmurka.net
 *
 * efnet-pl to proxy IRCowe, zamieniajce polskie znaki w standardzie 
 * Windows-1250 (uywanym m.in. przez mIRCa) na standard ISO-8859-2, 
 * powszechnie uywany w Internecie. efnet-pl zostao zaprojektowane 
 * tak, eby maksymalnie uatwi uywanie go. Oprcz tumaczenia polskich 
 * znakw posiada wbudowany serwer identyfikacji, zwracajcy odpowiedzi 
 * w zalenoci od nazwy uytkownika, przekazanej przez program mIRC. 
 * Proxy moe by take uywane do czenia si z innymi serwerami ni 
 * irc.efnet.pl.
 *
 * Uycie: W wikszoci przypadkw wystarczy po prostu uruchomienie 
 * programu efnet-pl.exe i wpisanie w mIRCu serwera o nazwie localhost. 
 * Jeli masz z tym problemy, zajrzyj na stron www.efnet.pl do dziau 
 * "Jak zacz", gdzie dokadniej opisalimy sposb konfiguracji mIRCa.
 *
 * Dla zaawansowanych uytkownikw przewidzielimy wiksz kontrol nad 
 * programem. W linii polece mona poda jedn lub wicej opcji spord:
 *
 *  * -h: powoduje wypisanie krtkiego ekranu pomocy i wyjcie.
 *
 *  * -i ident: moe wynosi -, + lub nazwa. Jeli zostanie podany - (minus), 
 *    serwer identyfikacji zostanie wyczony. Jeli zostanie podany +, to 
 *    serwer zostanie wczony, a nazwa uytkownika zwracana przez niego 
 *    bdzie brana z komendy USER, wysyanej przez program mIRC. Jeli 
 *    zostanie podana nazwa, to serwer zignoruje komend USER i bdzie 
 *    zwraca podan nazw. Jeli poczenie z serwerem identyfikacji 
 *    nastpi wczeniej ni komenda USER, to zostanie zwrcony bd 
 *    NO-USER. Domyln wartoci jest +.
 *
 *  * -b port: okrela podstawowy port, na ktrym sucha efnet-pl. Proxy 
 *    przyjmuje tylko jedno poczenie na ten port. Jeli podczas trwajcego 
 *    poczenia nadejdzie inne poczenie, to zostanie ono automatycznie 
 *    zakoczone. Domylna warto: 6667.
 *
 *  * -l host: okrela hosta lub adres IP interfejsu, na ktrym ma sucha 
 *    efnet-pl. To przydatne jeli chcemy mie stuprocentow pewno, e 
 *    nikt spoza lokalnej maszyny nie poczy si z serwerem. Mona poda 
 *    -, wtedy program bdzie sucha na wszystkich interfejsach. Domylna 
 *    warto: 127.0.0.1.
 *
 *  * -a port: okrela port, na ktrym sucha serwer identyfikacji. Jeli 
 *    podano opcj -i -, to warto jest ignorowana. Serwer identyfikacji 
 *    sucha na wszystkich interfejsach.
 *
 *  * -s serwer: serwer, z ktrym program si czy. Przydatne jeli kto 
 *    chce uywa proxy do pocze z innymi serwerami, ni irc.efnet.pl. 
 *    Domylna warto: irc.efnet.pl.
 *
 *  * -p port: port, na ktrym proxy czy si z serwerem IRC. Przydatne, 
 *    jeli kto chce uywa efnet-pl do transkodowania innego protokou 
 *    ni IRC. Domylna warto: 6667.
 *
 * Proxy przystosowane jest do pracy z jednym uytkownikiem. Oznacza to, 
 * e umoliwia jednoczesne poczenie tylko jednego programu mIRC, tylko 
 * jednego serwera IRC do serwera identyfikacji, itp.
 *
 * Programem mona sterowa z klawiatury. Przyjmowane klawisze:
 *
 *   q: natychmiastowe wyjcie z programu.
 *   k: zabicie biecego poczenia (mIRCa z proxy i proxy z serwerem).
 *   K: zabicie biecego poczenia serwera IRC z serwerem autoryzacji.
 *
 * Ze wzgldu na jednouytkownikowe zastosowanie w programie nie 
 * zaimplementowano obsugi timeoutw, czyli ogranicze czasowych 
 * na wykonanie okrelonych zada. Ze wzgldu na swoj elastyczno, 
 * po wyczeniu sprawdzania komendy USER (opcja -i - lub -i +ident) 
 * program moe robi za proxy take dla usug niezwizanych z IRCem, 
 * jak np. Usenet News.
 *
 * Program wywietla wszystkie uyteczne informacje na konsoli tekstowej. 
 * Nie tworzy adnych plikw na dysku ani w aden sposb, poza translacj 
 * znakw, nie ingeruje w dane przesyane midzy programem mIRC i serwerem. 
 * Program jest darmowy, mona rozpowszechnia go na dowolnych nonikach 
 * pod warunkiem, e nie bdzie w aden sposb zmieniony i zostan doczone 
 * pliki: efnet-pl.exe (plik wykonywalny), efnet-pl.txt (ten opis) oraz 
 * efnet-pl.c (kompletny kod rdowy). W zwizku ze sposobem dystrybucji 
 * programu ani autor ani firma ATM S.A. nie daje adnej gwarancji na niego, 
 * na to e bdzie dziaa poprawnie ani nawet na to, e bdzie dziaa 
 * w ogle, jednak w przypadku problemw technicznych warto skontaktowa 
 * si z autorem (adres podany na pocztku tego pliku).
 *
 * Po skompilowaniu program trzeba zlinkowa z bibliotek obsugujc 
 * Windows Sockets, np. watcom\lib386\nt\wsock32.lib.
 * 
 * Changelog:
 *
 *  * [09.07.2004] v1.0a - mirc-pl.
 *  * [12.08.2004] v1.1 - mirc-pl dla sieci efnet.
 *  * [18.09.2004] v2.0 - kompletne przepisanie mirc-pl, dodanie wielu opcji.
 *  * [24.09.2004] v2.1 - poprawienie zgoszonego przez Jacka Wojaczyskiego 
 *                        buga w funkcji tunelujcej.
 *  * [30.12.2006] v2.2 - poprawienie zgoszonego przez Marcina Frankowskiego 
 *                        buga w funkcji parsujcej lini polece.
 */

#include <stdarg.h>
#include <string.h>
#include <conio.h>
#include <stdio.h>
#include <time.h>
#include <nt/winsock.h>

enum {	/* okrelenie rnych standardw kodowana */
	CP_ISO = 0,	/* ISO-8859-2 (oglnowiatowy standard) */
	CP_IBM,		/* IBM-852 (MS-DOS, konsola tekstowa) */
	CP_WIN		/* CP-1250 (MS-Windows) */
};

enum {	/* kierunki przepywu danych dla handle_tunnel() */
	DIR_MIRC_SERVER = 0,
	DIR_SERVER_MIRC
};

char wsa_ok = 0;	/* czy zainicjowano winsock? */
char cinit = 0;		/* czy czeka na USER? tylko przy ident = "+" */
SOCKET bfd, afd;	/* gniazda na ktrych program sucha */
SOCKET cfd, cafd;	/* poczone gniazda */
SOCKET sfd;		/* gniazdo poczenia z serwerem */
char *ident = NULL;	/* ident pobrany z USER */

struct conf_typ {	/* konfiguracja */
	char *ident;	/* typ identa (-, +, +nazwa) */
	char *bhost;	/* host do ktrego trzeba si bindowa */
	char *chost;	/* host z ktrym proxy si czy */
	int aport;	/* port identa (auth) */
	int bport;	/* port na ktrym program sucha */
	int cport;	/* port na ktrym program czy si z hostem */
} conf;

/* prototypy funkcji. poszczeglne funkcje s opisane niej. */

char conv (char from, char to, char ch);
void xprintf (char panic, char *fmt, ...);
void free_resources (void);
void init_wsock (void);
SOCKET bind_socket (char conn, char *host, int port);
void fasthelp (void);
void load_conf (int ac, char **av);
SOCKET do_accept (SOCKET fd);
void handle_ident (void);
void handle_tunnel (char dir);
void watch_fds (void);
int main (int ac, char **av);

/*
 * char conv (char from, char to, char ch);
 *
 * Przekodowuje znak z jednego standardu na inny. Jeli znak nie 
 * zostanie rozpoznany jako pasujcy do podanego standardu, zwraca 
 * go bez zmian.
 *
 * Wejcie:
 *   from, to: kodowanie wejciowe i wyjciowe.
 * 
 * Wyjcie:
 *   Funkcja zwraca przekodowany znak.
 */

char conv (char from, char to, char ch)
{
	static char ctab[3][19] = {
		0xEA, 0xF3, 0xB1, 0xB6, 0xB3, 0xBF, 0xBC, 0xE6, 0xF1,
		0xCA, 0xD3, 0xA1, 0xA6, 0xA3, 0xAF, 0xAC, 0xC6, 0xD1, 0,
		0xA9, 0xA2, 0xA5, 0x98, 0x88, 0xBE, 0xAB, 0x86, 0xE4,
		0xA8, 0xE0, 0xA4, 0x98, 0x9D, 0xBD, 0x8D, 0x8F, 0xE3, 0,
		0xEA, 0xF3, 0xB9, 0x9C, 0xB3, 0xBF, 0x9F, 0xE6, 0xF1, 
		0xCA, 0xD3, 0xA5, 0x8C, 0xA3, 0xAF, 0x8F, 0xC6, 0xD1, 0
	};
	int i = 0;

	while (ctab[from][i])
		if (ch == ctab[from][i])
			return ctab[to][i];
		else
			i++;

	return ch;
}

/*
 * void xprintf (char panic, char *fmt, ...);
 * 
 * Wypisuje na konsoli tekst, poprzedzajc go aktualnym czasem 
 * i koczc znakiem nowej linii. Jeli panic != 0, to wypisuje 
 * informacj o tym, e naley wcisn dowolny klawisz eby wyj, 
 * czeka na wcinicie go i wychodzi, zwalniajc zainicjowane 
 * wczeniej zasoby. Przyjmuje, e tekst jest kodowany jako 
 * Windows-1250, a konsola poprawnie wywietla znaki kodowane 
 * w IBM-852.
 *
 * Wejcie:
 *   fmt i lista argumentw: tekst do wypisania.
 *   panic: opisane wyej.
 *
 * Wyjcie:
 *   Funkcja nie zwraca adnej wartoci.
 */

void xprintf (char panic, char *fmt, ...)
{
	va_list args;
	char buf[320], tstr[9], *ptr;
	struct tm *tm;
	time_t t;

	/* stworzenie tekstu w buforze */
	va_start (args, fmt);
	vsnprintf (buf, sizeof(buf), fmt, args);
	va_end (args);

	/* przekodowanie bufora z windows na ibm */
	ptr = buf;
	while (*ptr) {
		*ptr = conv(CP_WIN, CP_IBM, *ptr);
		ptr++;
	}

	/* pobranie aktualnego czasu do date_str */
	t = time(NULL);
	tm = localtime(&t);
	strftime (tstr, sizeof(tstr), "%H.%M.%S", tm);

	/* wypisanie tekstu na konsoli */
	printf ("[%s] %s\r\n", tstr, buf);

	/* jeli panic = 0, to wszystko */
	if (!panic)
		return;

	/* zwolnienie uywanych zasobw */
	free_resources();

	/* wypisanie na konsoli tekstu poegnalnego. rekurencja :) */
	xprintf (0, "Wcinij dowolny klawisz, eby powrci do systemu.");

	/* poczekanie na znak, zwolnienie zasobw i wyjcie */
	getch();
	_exit (0);
}

/*
 * void free_resources (void);
 *
 * Funkcja zwalnia zasoby uywane przez program (zamyka winsocki 
 * i zwalnia ident).
 *
 * Wejcie:
 *   Brak.
 *
 * Wyjcie:
 *   Brak.
 */

void free_resources (void)
{
	/* pozamykanie socketw */
	if (sfd)
		closesocket (sfd);

	if (cfd)
		closesocket (cfd);

	if (cafd)
		closesocket (cafd);

	if (afd)
		closesocket (afd);

	if (bfd)
		closesocket (bfd);

	/* deinicjalizacja winsock */
	if (wsa_ok) {
		WSACleanup();
		wsa_ok = 0;
	}

	/* zwolnienie pamici zaalokowanej na ident */
	if (ident)
		free (ident);
}

/*
 * void init_wsock (void);
 *
 * Inicjuje Windows Sockets, ustawia afd, bfd, cfd, cafd, 
 * sfd, cinit i wsa_ok.
 *
 * Wejcie:
 *   Brak.
 *
 * Wyjcie:
 *   Brak.
 */

void init_wsock (void)
{
	long rc;
	WSADATA wsa;

	rc = WSAStartup(MAKEWORD(2, 0), &wsa);
	if (rc)
		xprintf (1, "WSAStartup: %d.", rc);

	afd = bfd = 0;
	cfd = cafd = 0;
	sfd = 0;
	cinit = 0;
	wsa_ok = 1;
}

/*
 * SOCKET bind_socket (char conn, char *host, int port);
 *
 * Tworzy gniazdo suchajce na podanym hocie i porcie (jeli 
 * conn = 0) lub poczone z podanym hostem na podanym porcie 
 * (jeli conn = 1). Jeli conn = 0 i host = NULL albo -, to 
 * sucha na wszystkich interfejsach.
 *
 * Wejcie:
 *   host, port: gdzie sucha lub gdzie si poczy.
 *
 * Wyjcie:
 *   Funkcja zwraca deskryptor do gniazda.
 */

SOCKET bind_socket (char conn, char *host, int port)
{
	SOCKET sock;
	SOCKADDR_IN addr;
	struct hostent *hent;
	long rc;

	/* znalezienie adresu IP hosta */
	if (!host || (*host == '-' && !host[1]))
		hent = NULL;
	else {
		xprintf (0, "Ustalanie adresu hosta '%s'.", host);
		hent = gethostbyname(host);
		if (!hent)
			xprintf (1, "Nie mona znale nazwy hosta.");
	}

	if (conn)
		xprintf (0, "czenie z adresem %s:%u.", host, port);
	else if (host && *host != '-' && host[1])
		xprintf (0, "Suchanie na adresie %s:%u.", host, port);
	else
		xprintf (0, "Suchanie na porcie %u.", port);

	/* stworzenie gniazda */
	sock = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
	if (sock == INVALID_SOCKET)
		xprintf (1, "socket(): %d.", WSAGetLastError());

	/* wypenienie struktury okrelajcej adres */
	bzero (&addr, sizeof(SOCKADDR_IN));
	addr.sin_family = AF_INET;
	addr.sin_port = htons(port);
	if (hent)
		memcpy (&addr.sin_addr, hent->h_addr, hent->h_length);
	else
		addr.sin_addr.s_addr = INADDR_ANY;

	/* jeli chcemy si poczy */
	if (conn) {
		rc = connect(sock, (SOCKADDR *) &addr, sizeof(SOCKADDR_IN));
		if (rc == SOCKET_ERROR)
			xprintf (1, "connect(): %d.", WSAGetLastError());

		return sock;
	}

	/* ustawienie adresu gniazda */
	rc = bind(sock, (SOCKADDR *) &addr, sizeof(SOCKADDR_IN));
	if (rc == SOCKET_ERROR)
		xprintf (1, "bind(): %d.", WSAGetLastError());

	/* i rozpoczcie suchania na nim */
	rc = listen(sock, 10);	/* 10 wystarczy */
	if (rc == SOCKET_ERROR)
		xprintf (1, "listen(): %d.", WSAGetLastError());

	/* ok, zwrcenie deskryptora */
	return sock;
}

/*
 * void fasthelp (void);
 *
 * Wywietla na ekranie krtki spis opcji.
 *
 * Wejcie:
 *   Brak.
 *
 * Wyjcie:
 *   Brak.
 */

void fasthelp (void)
{
	xprintf (0, "efnet-pl.exe");
	xprintf (0, "Najnowsza wersja: http://www.efnet.pl/efnet-pl.zip");
	xprintf (0, "Skargi i wnioski: Adam Wysocki, gophi <at> apcoh.org");
	xprintf (0, "");
	xprintf (0, "Skadnia: efnet-pl.exe [opcje]");
	xprintf (0, "");
	xprintf (0, "Opcje:");
	xprintf (0, "  -h: ten ekran pomocy");
	xprintf (0, "  -i: ident (-, +, +nazwa)");
	xprintf (0, "  -b: port, do ktrego program si binduje");
	xprintf (0, "  -l: host, do ktrego program si binduje");
	xprintf (0, "  -a: port, na ktrym sucha serwer identyfikacji");
	xprintf (0, "  -s: host, z ktrym program si czy");
	xprintf (0, "  -p: port, z ktrym program si czy");
	xprintf (0, "");
	xprintf (0, "Dokadniejszy opis opcji znajduje si w pliku efnet-pl.txt.");
	xprintf (0, "");
}

/*
 * void load_conf (int ac, char **av);
 *
 * Funkcja wypenia globaln struktur conf na podstawie przekazanych 
 * w linii komend argumentw.
 *
 * Wejcie:
 *   ac, av: lista argumentw przekazana do main.
 *
 * Wyjcie:
 *   Brak.
 */

void load_conf (int ac, char **av)
{
	/* watcom nie udostpnia getopt */
	int i;
	unsigned char lastopt = 0;
	static char opts[] = "iblasp";	/* opcje (poza -h) */

	/* wypenienie struktury domylnymi wartociami */
	conf.ident = "+";
	conf.bhost = "127.0.0.1";
	conf.chost = "irc.efnet.pl";
	conf.aport = 113;
	conf.bport = 6667;
	conf.cport = 6667;

	/* przejrzenie listy argumentw. od 1, bo av[0] to efnet-pl.exe */
	for (i = 1; i < ac; i++) {
		if (!lastopt) {		/* jeli szukamy opcji */
			if (av[i][0] == '-' && !av[i][2]) {	/* format -n */
				lastopt = av[i][1];
				if (lastopt == 'h') {	/* fasthelp */
					fasthelp();
					xprintf (1, "Wywietlono pomoc.");
				} else {	/* inna opcja. jaka? */
					char *opt = opts;

					while (*opt)
						if (*opt == lastopt)
							break;
						else
							opt++;

					if (!*opt)
						xprintf (1, "Nieznana opcja '-%c'.", lastopt);
				}
			} else		/* jaki inny format */
				xprintf (1, "Nieprawidowy argument '%s'.", av[i]);
		} else {	/* lastopt jest ustawione */
			switch (lastopt) {
				case 'i':
					conf.ident = av[i];
					break;
				case 'b':
					conf.bport = atoi(av[i]);
					break;
				case 'l':
					conf.bhost = av[i];
					break;
				case 'a':
					conf.aport = atoi(av[i]);
					break;
				case 's':
					conf.chost = av[i];
					break;
				case 'p':
					conf.cport = atoi(av[i]);
					break;
			}

			lastopt = 0;	/* eby parsowa nastpn opcj */
		}
	}

	/* koniec ptli sprawdzania. bya jaka niezakoczona opcja? */
	if (lastopt)
		xprintf (1, "Opcja '-%c' wymaga podania parametru.", lastopt);
}

/*
 * SOCKET do_accept (SOCKET fd);
 *
 * Przyjmuje poczenie na danym suchajcym gniedzie, wypisujc 
 * na konsoli adres IP i port, z ktrego przyszo.
 *
 * Wejcie:
 *   fd: suchajce gniazdo na ktrym czeka poczenie.
 *
 * Wyjcie:
 *   Funkcja zwraca poczone gniazdo.
 */

SOCKET do_accept (SOCKET fd)
{
	SOCKADDR_IN addr;
	int sz = sizeof(SOCKADDR_IN);

	/* przyjcie poczenia */
	fd = accept(fd, (SOCKADDR *) &addr, &sz);
	if (fd == INVALID_SOCKET)
		xprintf (1, "accept(): %d.", WSAGetLastError());

	if (fd == bfd)
		xprintf (0, "Poczenie spod %s:%u.", inet_ntoa(addr.sin_addr), ntohs(addr.sin_port));
	else
		xprintf (0, "Poczenie ident spod %s:%u.", inet_ntoa(addr.sin_addr), ntohs(addr.sin_port));

	return fd;
}

/*
 * void handle_ident (void);
 *
 * Obsuga deskryptora cafd. Wywoywane, jeli na cafd pojawiaj si 
 * dane lub zdalna strona zamkna poczenie.
 *
 * Wejcie:
 *   Brak.
 *
 * Wyjcie:
 *   Brak.
 */

void handle_ident (void)
{
	static char buf[2048];
	static int bpos = 0;
	int p[2], rs;
	int total = 0, len;

	/* odebranie portu rdowego i docelowego */
	rs = recv(cafd, buf + bpos, sizeof(buf) - (bpos + 1), 0);
	if (rs == -1)
		xprintf (1, "recv(): %d.", WSAGetLastError());
	else if (!rs) {
		xprintf (0, "Serwer zakoczy poczenie ident.");
		closesocket (cafd);
		cafd = 0;
		return;
	}

	bpos += rs;
	if (bpos >= (sizeof(buf) - 1))
		xprintf (1, "bpos > (sizeof(buf) - 1): %d, %d", bpos, sizeof(buf) - 1);
	buf[bpos] = 0;	/* dla strchr  i sscanf */

	if (!strchr(buf + bpos - rs, '\n'))
		return;

	bpos = 0;

	/* wycignicie portw z odebranego stringa */
	p[0] = p[1] = 0;
	sscanf (buf, "%u,%u", &p[0], &p[1]);

	/* wygenerowanie odpowiedzi */
	if (*conf.ident == '+' && !conf.ident[1])
		if (ident)
			snprintf (buf, sizeof(buf), "%u , %u : USERID : UNIX : %s\r\n", p[0], p[1], ident);
		else
			snprintf (buf, sizeof(buf), "%u , %u : ERROR : NO-USER\r\n", p[0], p[1]);
	else if (*conf.ident == '+')
		snprintf (buf, sizeof(buf), "%u , %u : USERID : UNIX : %s\r\n", p[0], p[1], conf.ident + 1);
	else
		snprintf (buf, sizeof(buf), "%u , %u : ERROR : NO-USER\r\n", p[0], p[1]);

	total = 0;
	len = strlen(buf);
	while (total != len) {
		rs = send(cafd, buf + total, len - total, 0);
		if (rs == -1)
			xprintf (1, "send(): %d.", WSAGetLastError());
		else if (!rs) {
			xprintf (0, "Serwer zamkn poczenie ident.");
			closesocket (cafd);
			cafd = 0;
		} else
			total += rs;
	}

	/* zamknicie poczenia ident */
	closesocket (cafd);
	cafd = 0;
}

/*
 * void handle_tunnel (char dir);
 *
 * Obsuga tunelu. Wywoywane, jeli na cfd lub sfd pojawi si 
 * dane lub ktra ze stron zamkna poczenie. dir moe by 
 * rwne DIR_MIRC_SERVER lub DIR_SERVER_MIRC.
 *
 * Wejcie:
 *   dir: kierunek przepywu danych.
 *
 * Wyjcie:
 *   Brak.
 */

void handle_tunnel (char dir)
{
	char buf[1024];
	int rs, ws, i = 0, total = 0;
	char from, to;
	SOCKET *s, *d;

	/* *s - rdo. *c - cel. */
	if (dir == DIR_MIRC_SERVER) {
		s = &cfd;
		d = &sfd;
		from = CP_WIN;
		to = CP_ISO;
	} else {
		s = &sfd;
		d = &cfd;
		from = CP_ISO;
		to = CP_WIN;
	}

	/* ok, odczyt danych ze rda */
	rs = recv(*s, buf, sizeof(buf), 0);
	if (rs == -1)
		xprintf (1, "recv(): %d.", WSAGetLastError());
	else if (!rs) {
		xprintf (0, "%s zamkn poczenie.", *s == cfd ? "mIRC" : "Serwer");
		closesocket (cfd);
		closesocket (sfd);
		cfd = sfd = 0;
		if (ident) {
			free (ident);
			ident = NULL;
		}
		return;
	}

	/* przekodowanie danych */
	while (i != rs) {
		buf[i] = conv(from, to, buf[i]);
		i++;
	}

	/* zapis danych do celu */
	total = 0;
	while (total != rs) {
		ws = send(*d, buf + total, rs - total, 0);
		if (ws == -1)
			xprintf (1, "send(): %d.", WSAGetLastError());
		else if (!ws) {
			xprintf (0, "%s zamkn poczenie.", *d == cfd ? "mIRC" : "Serwer");
			closesocket (cfd);
			closesocket (sfd);
			cfd = sfd = 0;
			if (ident) {
				free (ident);
				ident = NULL;
			}
		} else
			total += ws;
	}
}

/*
 * void watch_fds (void);
 *
 * Funkcja obserwuje deskryptory gniazd (select) i jeli ktre 
 * gniazdo co zrobi, wywouje odpowiedni funkcj. Obserwowane 
 * deskryptory to stdin (0), afd i bfd (czy nie nadeszy poczena) 
 * oraz (jeli istniej) cfd, cafd i sfd.
 *
 * Wejcie:
 *   Brak.
 *
 * Wyjcie:
 *   Brak.
 */

void watch_fds (void)
{
	fd_set fds;
	int maxfd, fd;
	int rc;
	struct timeval tv;
	static char old_cinit = 0;
	static char pbuf[1024];
	int rs;
	static int ppos = 0;

	maxfd = 0;
	if (afd > maxfd)
		maxfd = afd;
	if (bfd > maxfd)
		maxfd = bfd;
	if (cfd > maxfd)
		maxfd = cfd;
	if (cafd > maxfd)
		maxfd = cafd;
	if (sfd > maxfd)
		maxfd = sfd;
	maxfd++;	/* wymagane przez select */

	/* pod Windows select() nie potrafi sprawdza stanu deskryptorw 
	 * nie bdcych gniazdami, tak jak stdin. Szkoda... Trzeba troch 
	 * kombinowa. Pod uniksami nie ma takich problemw... */

	FD_ZERO (&fds);
	/* FD_SET (0, &fds);	*/	/* stdin */
	FD_SET (bfd, &fds);
	if (afd)
		FD_SET (afd, &fds);
	if (cfd)
		FD_SET (cfd, &fds);
	if (cafd)
		FD_SET (cafd, &fds);
	if (sfd)
		FD_SET (sfd, &fds);

	tv.tv_sec = 0;
	tv.tv_usec = 50000;	/* eby program dobrze reagowa na klawiatur */

	rc = select(maxfd, &fds, NULL, NULL, &tv);
	if (rc == -1)	/* wystpi bd */
		xprintf (1, "select(): %d.", WSAGetLastError());

	/* teraz wiemy, e przynajmniej jeden deskryptor zmieni stan 
	 * (moliwe e stdin). test? */

	/* najpierw stdin */

	if (kbhit())
		switch (getch()) {
			case 'q':
				xprintf (1, "Wyjcie.");
				break;
			case 'k':
				if (cfd) {
					xprintf (0, "Zakoczenie poczenia IRC.");
					closesocket (cfd);
					cfd = 0;
				} else
					xprintf (0, "Poczenie IRC nie jest aktywne.");
				break;
			case 'K':
				if (cafd) {
					xprintf (0, "Zakoczenie poczenia ident.");
					closesocket (cafd);
					cafd = 0;
				} else
					xprintf (0, "Poczenie ident nie jest aktywne.");
				break;
			default:
				break;
		}

	/* teraz poszczeglne deskryptory */

	if (FD_ISSET(afd, &fds)) {	/* auth fd - serwer ident */
		fd = do_accept(afd);
		if (cafd) {
			xprintf (0, "Poczenie ident jest ju aktywne.");
			closesocket (fd);
		} else
			cafd = fd;
	}

	if (FD_ISSET(bfd, &fds)) {	/* bind fd - serwer proxy */
		fd = do_accept(bfd);
		if (cfd) {
			xprintf (0, "Poczenie IRC jest ju aktywne.");
			closesocket (fd);
		} else {
			cfd = fd;
			/* jeli ident = "+", to ustawiamy flag, ktra 
			 * oznacza "nowe poczenie, sprawd USER". 
			 * jeli ident jest innego typu, to ta flaga 
			 * nie jest potrzebna, bo program nie analizuje 
			 * danych. */
			if (*conf.ident == '+' && !conf.ident[1])
				cinit = old_cinit = 1;
			else
				sfd = bind_socket(1, conf.chost, conf.cport);
		}
	}

	if (FD_ISSET(cafd, &fds))	/* conn auth fd - poczenie ident */
		handle_ident();

	if (FD_ISSET(cfd, &fds)) {	/* conn fd - poczenie z mIRCem */
		/* jeli cinit = 1, to informacje odczytywane od klienta s 
		 * gromadzone w pbuf. Jeli wrd tych informacji znajdzie 
		 * si cig '\nUSER ', a po nim przynajmniej jedno '\n', 
		 * to proxy wyciga z niego ident, czy si z serwerem, 
		 * ustawia cinit = 0, wysya do serwera dane odebrane do 
		 * tej pory od klienta i pracuje tak jak do tej pory, 
		 * tunelujc poczenie. chodzi o to, eby wychwyci 
		 * rejestracj mIRCa na serwerze przed poczeniem z tym 
		 * serwerem i poczy si dopiero wtedy, kiedy bdziemy 
		 * w stanie odpowiedzie serwerowi na zapytanie o ident.
		 */

		if (cinit) {
			rs = recv(cfd, pbuf + ppos, sizeof(pbuf) - (ppos + 1), 0);
			if (rs == -1)
				xprintf (1, "recv(): %d.", WSAGetLastError());
			else if (!rs) {
				xprintf (0, "Klient zakoczy poczenie.");
				cinit = 0;
				old_cinit = 0;
				ppos = 0;
				closesocket (cfd);
				cfd = 0;
			} else {
				int i;

				ppos += rs;
				if (ppos >= (sizeof(pbuf) - 1))
					xprintf (1, "ppos > (sizeof(pbuf) - 1): %d, %d", ppos, sizeof(pbuf) - 1);

				pbuf[ppos] = 0;	/* bdzie nadpisane, ale dla strchr */
				/* znalezienie tekstu '\nUSER ' majcego gdzie dalej '\n' */
				if (ppos > 6)
					for (i = 0; i < (ppos - 6); i++)
						if (!strnicmp(pbuf + i, "\nUSER ", 6) && strchr(pbuf + i + 6, '\n')) {
							cinit = 0;
							ident = strdup(pbuf + i + 6);
							if (!ident)
								xprintf (1, "Brak pamici.");
							/* lame, ale dziaa. wyzerowanie 
							 * ident po pierwszej spacji. */
							strtok (ident, " ");
							xprintf (0, "mIRC zwrci ident '%s'.", ident);
						}
			}
		} else
			handle_tunnel (DIR_MIRC_SERVER);
	}

	if (old_cinit && !cinit) {	/* wanie ustawiono ident */
		int total = 0;

		sfd = bind_socket(1, conf.chost, conf.cport);

		/* wysanie pbuf do serwera */
		while (total != ppos) {
			rs = send(sfd, pbuf + total, ppos - total, 0);
			if (rs == -1)
				xprintf (1, "send(): %d.", WSAGetLastError());
			else if (!rs) {
				xprintf (0, "Serwer zamkn poczenie.");
				closesocket (sfd);
				closesocket (cfd);
				sfd = 0;
				cfd = 0;
			} else
				total += rs;
		}

		ppos = 0;
	}

	old_cinit = cinit;

	if (FD_ISSET(sfd, &fds))	/* server fd - poczenie z serwerem */
		handle_tunnel (DIR_SERVER_MIRC);
}

/*
 * int main (int ac, char **av);
 *
 * Gwna funkcja programu. Wywouje pozostae.
 *
 * Wejcie:
 *   ac, av: lista argumentw, przekazywana przez system.
 *
 * Wyjcie:
 *   Funkcja teoretycznie zwraca do systemu 0. W praktyce 
 *   program koczy si w funkcji xprintf, wywoanej 
 *   z parametrem panic = 1.
 */

int main (int ac, char **av)
{
	load_conf (ac, av);
	init_wsock();
	if (*conf.ident != '-' || conf.ident[1])
		afd = bind_socket(0, NULL, conf.aport);
	bfd = bind_socket(0, conf.bhost, conf.bport);

	/* gwna ptla programu */
	while (!0)
		watch_fds();

	/* NOTREACHED */

	return 0;
}
